<?php include 'config.php'; ?>
<!DOCTYPE html>
<html>
<head>
<title>NGO Enterprise V5 Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="bg-light">
<div class="container mt-4">
<h3>Multi-Branch NGO Dashboard</h3>

<?php
$total_b=$conn->query("SELECT COUNT(*) c FROM beneficiaries")->fetch_assoc()['c'];
$total_d=$conn->query("SELECT SUM(amount) s FROM distributions")->fetch_assoc()['s'];
?>

<div class="row">
<div class="col-md-6">
<div class="card p-3 shadow">
<h5>Total Beneficiaries</h5>
<h2><?php echo $total_b; ?></h2>
</div>
</div>
<div class="col-md-6">
<div class="card p-3 shadow">
<h5>Total Aid Distributed</h5>
<h2>Rs. <?php echo $total_d?$total_d:0; ?></h2>
</div>
</div>
</div>

<h4 class="mt-5">Monthly Distribution</h4>
<canvas id="chart1"></canvas>

<?php
$data=$conn->query("SELECT MONTH(distribution_date) m,SUM(amount) s FROM distributions GROUP BY m");
$months=[];$amounts=[];
while($r=$data->fetch_assoc()){ $months[]=$r['m']; $amounts[]=$r['s']; }
?>

<script>
new Chart(document.getElementById('chart1'),{
type:'bar',
data:{
labels:<?php echo json_encode($months); ?>,
datasets:[{label:'Monthly Aid',data:<?php echo json_encode($amounts); ?>}]
}
});
</script>

</div>
</body>
</html>