<?php
require '../core/auth_check.php';
require '../config/db.php';

$total=$conn->query("SELECT COUNT(*) as c FROM beneficiaries")->fetch_assoc()['c'];
$monthly=$conn->query("SELECT COUNT(*) as c FROM distributions WHERE MONTH(distribution_date)=MONTH(CURDATE())")->fetch_assoc()['c'];
?>
<!DOCTYPE html>
<html>
<head>
<title>Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
<div class="container mt-4">
<h4>Analytics Dashboard</h4>
<div class="row">
<div class="col-md-4">
<div class="card p-3 shadow">
<h6>Total Beneficiaries</h6>
<h3><?=$total?></h3>
</div>
</div>
<div class="col-md-4">
<div class="card p-3 shadow">
<h6>This Month Distributions</h6>
<h3><?=$monthly?></h3>
</div>
</div>
</div>

<canvas id="chart" class="mt-4"></canvas>
</div>

<script>
const ctx=document.getElementById('chart');
new Chart(ctx,{
type:'bar',
data:{
labels:['Beneficiaries','Monthly Distributions'],
datasets:[{
label:'Statistics',
data:[<?=$total?>,<?=$monthly?>]
}]
}
});
</script>
</body>
</html>