
<?php
require '../core/auth_check.php';
require '../config/db.php';

$limit=25;
$page=$_GET['page']??1;
$offset=($page-1)*$limit;
$search=$_GET['search']??'';

$sql="SELECT * FROM beneficiaries 
WHERE NAME LIKE ? OR CNIC LIKE ? OR MOBILE LIKE ?
LIMIT $limit OFFSET $offset";

$stmt=$conn->prepare($sql);
$like="%$search%";
$stmt->bind_param("sss",$like,$like,$like);
$stmt->execute();
$result=$stmt->get_result();
?>
<!DOCTYPE html>
<html>
<head>
<title>Beneficiaries</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container-fluid mt-3">
<div class="d-flex justify-content-between">
<h4>Beneficiaries</h4>
<div>
<a href="../imports/import_csv.php" class="btn btn-secondary btn-sm">Import CSV</a>
<a href="../exports/export_excel.php" class="btn btn-warning btn-sm">Excel</a>
<a href="../exports/export_pdf.php" class="btn btn-danger btn-sm">PDF</a>
<a href="../auth/logout.php" class="btn btn-dark btn-sm">Logout</a>
</div>
</div>

<form class="my-3">
<div class="input-group">
<input name="search" class="form-control" placeholder="Search">
<button class="btn btn-primary">Search</button>
<a href="add.php" class="btn btn-success">Add</a>
</div>
</form>

<div class="table-responsive">
<table class="table table-striped table-bordered">
<tr><th>ID</th><th>Name</th><th>CNIC</th><th>Mobile</th><th>Photo</th><th>Action</th></tr>
<?php while($row=$result->fetch_assoc()): ?>
<tr>
<td><?=$row['ID']?></td>
<td><?=$row['NAME']?></td>
<td><?=$row['CNIC']?></td>
<td><?=$row['MOBILE']?></td>
<td><?php if($row['photo']) echo "<img src='../uploads/photos/".$row['photo']."' width='40'>"; ?></td>
<td>
<a href="../distributions/history.php?id=<?=$row['ID']?>" class="btn btn-info btn-sm">History</a>
</td>
</tr>
<?php endwhile; ?>
</table>
</div>
</div>
</body>
</html>
