
<?php
session_start();
require '../config/db.php';
require '../lang/lang.php';
if(!isset($_SESSION['user'])) header("Location: ../auth/login.php");

$limit=20;
$page=$_GET['page']??1;
$offset=($page-1)*$limit;
$search=$_GET['search']??'';

$sql="SELECT * FROM beneficiaries WHERE 
NAME LIKE ? OR CNIC LIKE ? OR MOBILE LIKE ?
LIMIT $limit OFFSET $offset";

$stmt=$conn->prepare($sql);
$like="%$search%";
$stmt->bind_param("sss",$like,$like,$like);
$stmt->execute();
$result=$stmt->get_result();
?>
<!DOCTYPE html>
<html>
<head>
<title><?=$t['beneficiaries']?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
<div class="d-flex justify-content-between">
<h4><?=$t['beneficiaries']?></h4>
<div>
<a href="?lang=en" class="btn btn-sm btn-primary">EN</a>
<a href="?lang=ur" class="btn btn-sm btn-success">اردو</a>
<a href="../auth/logout.php" class="btn btn-danger btn-sm"><?=$t['logout']?></a>
</div>
</div>

<form method="GET" class="my-3">
<div class="input-group">
<input name="search" class="form-control" placeholder="Search">
<button class="btn btn-primary">Search</button>
<a href="add.php" class="btn btn-success"><?=$t['add']?></a>
<a href="../exports/export_excel.php" class="btn btn-warning">Excel</a>
</div>
</form>

<div class="table-responsive">
<table class="table table-bordered">
<tr><th>ID</th><th><?=$t['name']?></th><th><?=$t['cnic']?></th><th><?=$t['mobile']?></th><th>Action</th></tr>
<?php while($row=$result->fetch_assoc()): ?>
<tr>
<td><?=$row['ID']?></td>
<td><?=$row['NAME']?></td>
<td><?=$row['CNIC']?></td>
<td><?=$row['MOBILE']?></td>
<td>
<a href="../distributions/history.php?id=<?=$row['ID']?>" class="btn btn-info btn-sm"><?=$t['distribution']?></a>
</td>
</tr>
<?php endwhile; ?>
</table>
</div>
</div>
</body>
</html>
