
<?php
session_start();
require '../config/db.php';
if($_SERVER["REQUEST_METHOD"]=="POST"){
$check=$conn->prepare("SELECT ID FROM beneficiaries WHERE CNIC=?");
$check->bind_param("s",$_POST['CNIC']);
$check->execute();
$check->store_result();
if($check->num_rows>0){
$error="CNIC already exists!";
}else{
$stmt=$conn->prepare("INSERT INTO beneficiaries(NAME,CNIC,MOBILE) VALUES(?,?,?)");
$stmt->bind_param("sss",$_POST['NAME'],$_POST['CNIC'],$_POST['MOBILE']);
$stmt->execute();
header("Location: index.php");
}
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Add</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script>
function formatCNIC(input){
let v=input.value.replace(/\D/g,'');
if(v.length>5) v=v.slice(0,5)+'-'+v.slice(5);
if(v.length>13) v=v.slice(0,13)+'-'+v.slice(13,14);
input.value=v;
}
</script>
</head>
<body>
<div class="container mt-4 col-md-6">
<h4>Add Beneficiary</h4>
<?php if(isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
<form method="POST">
<input name="NAME" class="form-control mb-2" placeholder="Name" required>
<input name="CNIC" class="form-control mb-2" placeholder="xxxxx-xxxxxxx-x" onkeyup="formatCNIC(this)" required>
<input name="MOBILE" class="form-control mb-2" placeholder="Mobile">
<button class="btn btn-success">Save</button>
</form>
</div>
</body>
</html>
