
<?php
session_start();
require '../config/db.php';

if($_SERVER["REQUEST_METHOD"]=="POST"){
    $stmt=$conn->prepare("SELECT * FROM users WHERE username=?");
    $stmt->bind_param("s",$_POST['username']);
    $stmt->execute();
    $res=$stmt->get_result();
    if($res->num_rows==1){
        $user=$res->fetch_assoc();
        if(password_verify($_POST['password'],$user['password'])){
            $_SESSION['user']=$user['username'];
            $_SESSION['role']=$user['role'];
            header("Location: ../beneficiaries/index.php");
            exit();
        }
    }
    $error="Invalid Login!";
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Login</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5 col-md-4">
<div class="card shadow p-4">
<h4 class="text-center">NGO System Login</h4>
<?php if(isset($error)) echo "<div class='alert alert-danger'>$error</div>"; ?>
<form method="POST">
<input name="username" class="form-control mb-3" placeholder="Username" required>
<input type="password" name="password" class="form-control mb-3" placeholder="Password" required>
<button class="btn btn-primary w-100">Login</button>
</form>
</div>
</div>
</body>
</html>
