<?php
session_start();
require '../config/db.php';
if (!isset($_SESSION['user'])) {
    header("Location: ../auth/login.php");
    exit();
}

$limit = 20;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;
$search = $_GET['search'] ?? '';

$sql = "SELECT * FROM beneficiaries WHERE 
        NAME LIKE ? OR SECOND_NAME LIKE ? OR CNIC LIKE ? 
        OR MOBILE LIKE ? OR LOCATION LIKE ? 
        LIMIT $limit OFFSET $offset";

$stmt = $conn->prepare($sql);
$like = "%$search%";
$stmt->bind_param("sssss",$like,$like,$like,$like,$like);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
<title>Beneficiaries</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
<h4>Beneficiaries</h4>

<form method="GET" class="mb-3">
<div class="input-group">
<input type="text" name="search" class="form-control" placeholder="Search...">
<button class="btn btn-primary">Search</button>
<a href="add.php" class="btn btn-success">Add New</a>
</div>
</form>

<div class="table-responsive">
<table class="table table-bordered table-striped">
<tr>
<th>ID</th><th>Name</th><th>CNIC</th><th>Mobile</th><th>Action</th>
</tr>
<?php while($row = $result->fetch_assoc()): ?>
<tr>
<td><?= $row['ID'] ?></td>
<td><?= $row['NAME'] ?></td>
<td><?= $row['CNIC'] ?></td>
<td><?= $row['MOBILE'] ?></td>
<td>
<a href="edit.php?id=<?= $row['ID'] ?>" class="btn btn-sm btn-warning">Edit</a>
<a href="delete.php?id=<?= $row['ID'] ?>" class="btn btn-sm btn-danger">Delete</a>
</td>
</tr>
<?php endwhile; ?>
</table>
</div>
</div>
</body>
</html>
