<?php
session_start();
require '../config/db.php';
if (!isset($_SESSION['user'])) {
    header("Location: ../auth/login.php");
    exit();
}

if($_SERVER["REQUEST_METHOD"] == "POST"){
    $stmt = $conn->prepare("INSERT INTO beneficiaries (NAME,CNIC,MOBILE) VALUES (?,?,?)");
    $stmt->bind_param("sss", $_POST['NAME'], $_POST['CNIC'], $_POST['MOBILE']);
    $stmt->execute();
    header("Location: index.php");
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Add Beneficiary</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<script>
function formatCNIC(input){
let value = input.value.replace(/\D/g,'');
if(value.length > 5) value = value.slice(0,5)+'-'+value.slice(5);
if(value.length > 13) value = value.slice(0,13)+'-'+value.slice(13,14);
input.value = value;
}
</script>
</head>
<body>
<div class="container mt-4">
<h4>Add Beneficiary</h4>
<form method="POST">
<input type="text" name="NAME" class="form-control mb-2" placeholder="Name" required>
<input type="text" name="CNIC" class="form-control mb-2" placeholder="xxxxx-xxxxxxx-x" onkeyup="formatCNIC(this)" required>
<input type="text" name="MOBILE" class="form-control mb-2" placeholder="Mobile">
<button class="btn btn-success">Save</button>
</form>
</div>
</body>
</html>
